/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.ast.nodes;

import com.aptana.editor.php.core.typebinding.IMethodBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.match.ASTMatcher;
import org2.eclipse.php.internal.core.ast.nodes.AST;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.BodyDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org2.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;

public class MethodDeclaration
extends BodyDeclaration {
    private FunctionDeclaration function;
    private Comment comment;
    public static final ChildPropertyDescriptor FUNCTION_PROPERTY = new ChildPropertyDescriptor(MethodDeclaration.class, "function", FunctionDeclaration.class, true, true);
    public static final SimplePropertyDescriptor MODIFIER_PROPERTY = new SimplePropertyDescriptor(MethodDeclaration.class, "modifier", Integer.class, false);
    public static final ChildPropertyDescriptor COMMENT_PROPERTY = new ChildPropertyDescriptor(Comment.class, "comment", Comment.class, false, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(FUNCTION_PROPERTY);
        propertyList.add(MODIFIER_PROPERTY);
        propertyList.add(COMMENT_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Override
    public final SimplePropertyDescriptor getModifierProperty() {
        return MODIFIER_PROPERTY;
    }

    public MethodDeclaration(int start, int end, AST ast, int modifier, FunctionDeclaration function, boolean shouldComplete) {
        super(start, end, ast, modifier, shouldComplete);
        if (function == null) {
            throw new IllegalArgumentException();
        }
        this.setFunction(function);
    }

    public MethodDeclaration(int start, int end, AST ast, int modifier, FunctionDeclaration function) {
        this(start, end, ast, modifier, function, false);
    }

    public MethodDeclaration(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.comment != null) {
            this.comment.accept(visitor);
        }
        this.function.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.comment != null) {
            this.comment.traverseTopDown(visitor);
        }
        this.function.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.function.traverseBottomUp(visitor);
        if (this.comment != null) {
            this.comment.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<MethodDeclaration");
        this.appendInterval(buffer);
        buffer.append(" modifier='").append(this.getModifierString()).append("'>\n");
        this.function.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</MethodDeclaration>");
    }

    @Override
    public int getType() {
        return 42;
    }

    public FunctionDeclaration getFunction() {
        return this.function;
    }

    public void setFunction(FunctionDeclaration expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        FunctionDeclaration oldChild = this.function;
        this.preReplaceChild(oldChild, expression, FUNCTION_PROPERTY);
        this.function = expression;
        this.postReplaceChild(oldChild, expression, FUNCTION_PROPERTY);
    }

    public void setComment(Comment expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Comment oldChild = this.comment;
        this.preReplaceChild(oldChild, expression, COMMENT_PROPERTY);
        this.comment = expression;
        this.postReplaceChild(oldChild, expression, COMMENT_PROPERTY);
    }

    public Comment getComment() {
        return this.comment;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == FUNCTION_PROPERTY) {
            if (get) {
                return this.getFunction();
            }
            this.setFunction((FunctionDeclaration)child);
            return null;
        }
        if (property == COMMENT_PROPERTY) {
            if (get) {
                return this.getComment();
            }
            this.setComment((Comment)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        FunctionDeclaration function = ASTNode.copySubtree(target, this.getFunction());
        int modifier = this.getModifier();
        MethodDeclaration result = new MethodDeclaration(this.getStart(), this.getEnd(), target, modifier, function, true);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IMethodBinding resolveMethodBinding() {
        return (IMethodBinding)this.getBinding();
    }
}

